﻿namespace Hims.Api.Controllers
{

    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using System.Threading.Tasks;
    using Shared.UserModels.TemplateDesign.Template;
  

    /// <inheritdoc />
    [Authorize]
    [Route("api/template")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class TemplateController : BaseController
    {
        /// <summary>
        /// The  template services.
        /// </summary>
        private readonly ITemplateService templateService;
     
        /// <inheritdoc />
        public TemplateController(ITemplateService templateService)
        {
            this.templateService = templateService;
        }

        /// <summary>
        /// Inserts the template asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("insert")]
        public async Task<ActionResult> InsertAsync([FromBody] InsertModel model)
        {
            model = (InsertModel)EmptyFilter.Handler(model);
            var response = await this.templateService.InsertAsync(model);
            return this.Success(response);
        }
    }
}
